/** @file   Size2D.h
 * @brief   Declaration of Size2D class.
 * @version $Revision: 1.1 $
 * @date    $Date: 2006/01/29 20:15:00 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_ENG2D_SIZE2D_H
#define H_ENG2D_SIZE2D_H

#include "eng2d_dll.h"

namespace eng2d {

/** @class  Size2D
 * @brief   Describes a 2d size (width, height).
 * @author  Tomi Lamminsaari
 *
 * 2d size information can be encapsulated in an instance of this class.
 * The data members @c iWidth and @c iHeight are public providing a quick
 * access to the size information.
 */
class DLLIMPORT Size2D
{
public:

  ///
  /// Constants, datatypes and static methods
  /// =======================================

  ///
  /// Constructors, destructor and operators
  /// ======================================

  /** Default constructor. Size is (0,0).
   */
  Size2D();

  /** Constructs an object that contains the given size.
   * @param   aWidth            Width
   * @param   aHeight           Height
   */
  Size2D( int aWidth, int aHeight );
  
  /** Destructor
   */
  ~Size2D();

  /** Copy constructor
   * @param   aAnother          Reference to another Size2D
   */
  Size2D( const Size2D& aAnother );

  /** An assignment operator
   * @param   aAnother          Reference to another Size2D
   * @return  Reference to this object.
   */
  Size2D& operator= ( const Size2D& aAnother );


  ///
  /// New public methods
  /// ==================

  /** Sets the size.
   * @param   aWidth            New width.
   * @param   aHeight           New height.
   */
  void SetSize( int aWidth, int aHeight );

  ///
  /// Getter methods
  /// ==============

  /** Returns the width.
   * @return  Width.
   */
  int Width() const;
  
  /** Returns the height.
   * @return  Height.
   */
  int Height() const;

protected:
  ///
  /// Protected interface
  /// ===================


public:
  ///
  /// Data members
  /// ============

  /** Width */
  int iWidth;
  /** Height */
  int iHeight;
};

};  // end of namespace

#endif
